// eslint-disable-next-line no-unused-vars
/* global sc, sca, parameters */
let $$ = require('cdev/debug')({ debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]', context: sca });
$$.md = require('/agorum/roi/customers/cdev.ncore/js/utils/md')($$);
$$.objects = require('common/objects').sc(sca);

let aguila = require('common/aguila');
let transaction = require('common/transaction');
// let templates = require('common/templates');
// let message = require('/agorum/roi/customers/agorum.composite/js/lib/message');

let utils = require('../idx-utils');

let uploadButtonText = 'Dokument(e) über Explorer auswählen ...';

let aon = require('./document-upload-view-aon')(true);
let widget = aguila.create(aon);

let insuranceRecord = null;

let grid = widget.down('grid');
let uploadButton = widget.down('uploadButton');
// let uploadContainer = widget.down('uploadContainer');

let elements = [
  'id',
  'name',
  'isg_xpert_archive_insName',
  'isg_xpert_archive_insNumber',
  'isg_xpert_archive_insBirthday',
  'isg_xpert_archive_processLvl2',
  'isg_xpert_archive_processLvl3',
  'ordernumber',
  'isg_xpert_archive_processDate',
  'isg_xpert_archive_class_code',
  'isg_xpert_archive_type_code',
  'isg_xpert_archive_event_code_list',
  'uploadContainer',
  'grid',
  'uploadButton',
];

let hideElements = hide => {
  elements.forEach(el => {
    let element = widget.down(el);
    if (element) element.hidden = hide;
  });
  // widget.hidden = hide;
};

let active = [];
let progress = {};
let percentage = progress => (progress * 100).toFixed(0) + '%';

// eslint-disable-next-line no-template-curly-in-string
let baseQuery = 'inpath:${FOLDERPATH:/agorum/roi/Files} area:mdb area:archive area:records';

let refreshSearchResult = widget => {
  try {
    let acicContainer = widget.container.container.container.container;
    let searchResult = acicContainer.down('resultContentContent').down('list').container;
    searchResult.fire('refresh');
    $$.debug('document-upload-view - refreshSearchResult', searchResult.type);
  } catch (e) {
    $$.debug('document-upload-view - refreshSearchResult', e);
  }
};

let validateInput = value => {
  let notNullOrEmpty = check => {
    return check && typeof check === 'string' && check.length > 0;
  };
  return (
    notNullOrEmpty(value.isg_xpert_archive_processLvl2) &&
    notNullOrEmpty(value.isg_xpert_archive_processLvl3) &&
    notNullOrEmpty(value.ordernumber) &&
    notNullOrEmpty(value.isg_xpert_archive_class_code) &&
    notNullOrEmpty(value.isg_xpert_archive_type_code) &&
    notNullOrEmpty(value.isg_xpert_archive_event_code_list)
  );
};

let findInsuranceRecord = obj => {
  if (insuranceRecord) return insuranceRecord;
  if (!obj) return null;
  let meta = $$.md.load(obj, /^isg/);
  let query = [
    baseQuery,
    'classname:folderobject',
    'isg_xpert_archive_insnumber:' + meta.isg_xpert_archive_insNumber,
  ].join(' ');
  let record = $$.objects.query(query).limit(1).find()[0];
  return record;
};

let getSelectionData = record => {
  // helper to evaluate selection data arrays
  // for current insurance record
  let extractUniqueSortedValues = data => {
    let result = {};
    data.rows.forEach(row => {
      Object.keys(row)
        .filter(key => key.startsWith('isg_xpert_'))
        .forEach(key => {
          if (!result[key]) {
            result[key] = {};
          }
          result[key][row[key]] = true;
        });
    });
    Object.keys(result).forEach(key => {
      result[key] = Object.keys(result[key]).sort();
    });
    return result;
  };

  if (record && record.ID) {
    // let meta = $$.md.load(insuranceRecord, /^isg/);
    let queryResult = $$.objects
      .query('inpath:' + record.ID + ' classname:FILEOBJECT')
      .search(/* 'isg_xpert_archive_processlvl2', 'isg_xpert_archive_processlvl3', */ 'isg_xpert_archive_ordernumber');

    return extractUniqueSortedValues(queryResult);
  }
};

let update = () => {
  // collect state for all files
  let files = widget.uploadQueue.concat(uploadButton.uploadQueue);

  // update grid, calculate total progress
  let count = files.length;
  let total = 0;
  let done = 0;

  grid.rows = files.map(file => {
    file.done = progress[file.id] || 0;

    total += file.size;
    done += file.done;

    return {
      name: file.name,
      progress: percentage(file.done / file.size),
    };
  });

  // update uploadButton text
  if (count > 0) {
    uploadButton.text = 'Uploading ' + count.toFixed(0) + ' files - ' + percentage(done / total);
  } else if (active > 0) {
    uploadButton.text = 'Finalizing ' + active.toFixed(0) + ' files...';
  } else {
    uploadButton.text = uploadButtonText;
  }
};

let updateProgress = (id, add) =>
  aguila.enter(() => {
    progress[id] = (progress[id] || 0) + add;
    update();
  });

let upload = is => {
  $$.debug('document-upload-view - upload', widget.value);
  if (!validateInput(widget.value)) {
    throw new Error('Bitte alle Eingabefelder ausfüllen!');
  }

  /* DEBUG: allow any file to check pdf validation */
  // check extension and restrict upload to PDF files (?)
  if (!is.name.toLowerCase().endsWith('.pdf')) {
    throw new Error('Es können nur PDF-Dokumente hochgeladen werden!');
  }
  /**/

  aguila
    .fork(
      () =>
        transaction(t => {
          // upload into new file
          let file = $$.objects.create('file', {
            name: is.name,
            target: insuranceRecord.createPath(
              '{0}/{1}/{2}'.format(
                widget.value.isg_xpert_archive_processLvl2 || 'LEISTUNG',
                widget.value.isg_xpert_archive_processLvl3 || 'BELEG',
                widget.value.ordernumber || 'AUFTRAG'
              )
            ),
          });

          // load metadata from insurance record ...
          // let meta = $$.md.load(insuranceRecord, /^isg/);

          $$.debug('document-upload-view - upload', widget.value, insuranceRecord);

          // mark as temporary
          file.systemFlags = 16384;

          let raf = new global.Packages.agorum.roi.ejb.common.DbRandomAccessFile(file.sessionController, file);

          try {
            raf.doNotMakeHistory = true;

            let buffer = global.java.lang.reflect.Array.newInstance(global.java.lang.Byte.TYPE, file.blockSize * 10);
            let commit = Date.now() + 10000;
            let read;

            while ((read = is.read(buffer)) > 0) {
              // write chunk
              raf.write(buffer, 0, read);

              // update progress for this file
              updateProgress(is.id, read);

              // commit every 10s
              if (Date.now() > commit) {
                t.restart();
                commit = Date.now() + 10000;
              }
            }
          } finally {
            raf.close();
          }

          // set metadata from widget value
          let meta = Object.assign(widget.value, {
            ag_metadata_collection: 'isg_xpert_archive_Document',
            // isg_xpert_archive_processLvl2: widget.value['processlvl2'],
            // isg_xpert_archive_processLvl3: widget.value['processlvl3'],
            isg_xpert_archive_orderNumber: widget.value['ordernumber'],
            isg_xpert_archive_images: [file.name],
            isg_xpert_archive_imgId: file.name,
            isg_xpert_archive_documentCounter: 0,
            isg_xpert_archive_processCode: '9',
          });

          // TODO: throw error if PDF validation fails
          meta = utils.validatePdfObject(file, meta);
          if (!meta['isg_xpert_archive_pdfValidation']) {
            throw new Error('Überprüfung des Dokumentes fehlgeschlagen [' + meta['isg_xpert_archive_pdfError'] + ']');
          }
          $$.md.save(file, meta);

          $$.debug('document-upload-view - uploaded', file, meta);

          // remove temporary mark
          file.systemFlags = 0;
        }) // end transaction
    )
    .catch(err => {
      // is.delete();
      // is = null;
      $$.log('Upload for [{0}] failed with [{1}]'.format(is.name, err));
      // message.alert('ERROR', 'Upload for [{0}] failed with [{1}]'.format(is.name, err));
      // throw new Error('Upload fehlgeschlagen [' + err.message + ']');
      throw err;

      // TODO: show error message
    })
    .finally(() => {
      // ensure stream is closed (already done if objects.create was successful)
      if (is) is.close();

      // remove from active uploads list
      active = active.filter(other => other !== is);

      update();
      refreshSearchResult(widget);
    });

  // add to active uploads list
  active.push(is);
};

// listen for queue updates
uploadButton.on('uploadQueueChanged', update);
widget.on('uploadQueueChanged', update);

// listen for new uploads
uploadButton.on('uploading', upload);
widget.on('uploading', upload);

// stop uploads if widget is destroyed
widget.on('destroyed', () => active.forEach(is => is.close()));

widget.on('idChanged', () => {
  hideElements(true);
  $$.debug('document-upload-view - idChanged', widget.id);
  if (widget.id) {
    let id = widget.id;
    aguila
      .fork(() => {
        let obj = null;
        obj = $$.objects.tryFind(id);
        if (obj) {
          insuranceRecord = findInsuranceRecord(obj);
          if (insuranceRecord) {
            return {
              selection: getSelectionData(insuranceRecord) || {},
              meta: $$.md.load(obj, /^isg/) || {},
            };
          }
        }
        return null;
      })
      .then(data => {
        if (data) {
          hideElements(false);
          $$.debug('document-upload-view - idChanged', data);
          widget.value = data.meta;
          widget.down('isg_xpert_archive_processDate').value = new Date();
          [
            /* 'isg_xpert_archive_processLvl2', 'isg_xpert_archive_processLvl3', */
            'isg_xpert_archive_orderNumber',
          ].forEach(item => {
            let element = widget.down(item.replace('isg_xpert_archive_', '').toLowerCase());
            if (element) {
              element.data = data.selection[item.toLowerCase()].map(value => {
                return {
                  value: value,
                  text: value,
                };
              });
              element.value = data.meta[item];
            }
          });
        }
      });
  }
});

widget.on('valueChanged', value => {
  if (validateInput(value)) {
    uploadButton.disabled = false;
  } else {
    uploadButton.disabled = true;
  }
  // $$.debug(widget.container);
  // hideElements(true);
});

/* DEBUG *
setImmediate(() => {
  widget.id = 7978342;
  $$.debug('document-upload-view - setImmediate', widget.id, parameters);
});
/**/

widget;
